
if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi


seq_len=720
model_name=Timemodel

# Weather

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/weather/ \
  --data_path weather.csv \
  --model_id weather_$seq_len'_'96 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,144,144] \
  --pred_len 96 \
  --d_model 96 \
  --n_model 21 \
  --t_model 48 \
  --enc_in 21 \
  --des 'Exp' \
  --itr 1 --batch_size 16  >logs/LongForecasting/$model_name'_'Weather_$seq_len'_'96.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/weather/ \
  --data_path weather.csv \
  --model_id weather_$seq_len'_'192 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,144,144] \
  --pred_len 192 \
  --d_model 96 \
  --n_model 21 \
  --t_model 48 \
  --enc_in 21 \
  --des 'Exp' \
  --itr 1 --batch_size 16  >logs/LongForecasting/$model_name'_'Weather_$seq_len'_'192.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/weather/ \
  --data_path weather.csv \
  --model_id weather_$seq_len'_'336 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,144,144] \
  --pred_len 336 \
  --d_model 96 \
  --n_model 21 \
  --t_model 48 \
  --enc_in 21 \
  --des 'Exp' \
  --itr 1 --batch_size 16  >logs/LongForecasting/$model_name'_'Weather_$seq_len'_'336.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/weather/ \
  --data_path weather.csv \
  --model_id weather_$seq_len'_'720 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,7,5] \
  --period [24,24,144,144] \
  --pred_len 720 \
  --d_model 96 \
  --n_model 21 \
  --t_model 48 \
  --enc_in 21 \
  --des 'Exp' \
  --itr 1 --batch_size 16  >logs/LongForecasting/$model_name'_'Weather_$seq_len'_'720.log

# traffic

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/traffic/ \
  --data_path traffic.csv \
  --model_id traffic_$seq_len'_'96 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,16,32] \
  --period [24,24,24,24] \
  --pred_len 96 \
  --d_model 12 \
  --n_model 862 \
  --t_model 48 \
  --enc_in 862 \
  --c_out 862 \
  --des 'Exp' \
  --itr 1 --batch_size 16 --learning_rate 0.05 >logs/LongForecasting/$model_name'_'traffic_$seq_len'_'96.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/traffic/ \
  --data_path traffic.csv \
  --model_id traffic_$seq_len'_'192 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,16,32] \
  --period [24,24,24,24] \
  --pred_len 192 \
  --d_model 12 \
  --n_model 862 \
  --t_model 48 \
  --enc_in 862 \
  --c_out 862 \
  --des 'Exp' \
  --itr 1 --batch_size 16 --learning_rate 0.05   >logs/LongForecasting/$model_name'_'traffic_$seq_len'_'192.log  

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/traffic/ \
  --data_path traffic.csv \
  --model_id traffic_$seq_len'_'336 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,16,32] \
  --period [24,24,24,24] \
  --pred_len 336 \
  --d_model 12 \
  --n_model 862 \
  --t_model 48 \
  --enc_in 862 \
  --c_out 862 \
  --des 'Exp' \
  --itr 1 --batch_size 16 --learning_rate 0.05   >logs/LongForecasting/$model_name'_'traffic_$seq_len'_'336.log  

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/traffic/ \
  --data_path traffic.csv \
  --model_id traffic_$seq_len'_'720 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [4,8,16,32] \
  --period [24,24,24,24] \
  --pred_len 720 \
  --d_model 12 \
  --n_model 862 \
  --t_model 48 \
  --enc_in 862 \
  --c_out 862 \
  --des 'Exp' \
  --itr 1 --batch_size 16 --learning_rate 0.05  >logs/LongForecasting/$model_name'_'traffic_$seq_len'_'720.log  

# Electricity

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/electricity/ \
  --data_path electricity.csv \
  --model_id Electricity_$seq_len'_'96 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6,1] \
  --sconv_kernel [4,8,16,32,3] \
  --period [24,24,24,24,12] \
  --pred_len 96 \
  --d_model 12 \
  --n_model 321 \
  --t_model 48 \
  --enc_in 321 \
  --des 'Exp' \
  --itr 1 --batch_size 16  --learning_rate 0.001 >logs/LongForecasting/$model_name'_'electricity_$seq_len'_'96.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/electricity/ \
  --data_path electricity.csv \
  --model_id Electricity_$seq_len'_'192 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6,1] \
  --sconv_kernel [4,8,16,32,3] \
  --period [24,24,24,24,12] \
  --pred_len 192 \
  --d_model 12 \
  --n_model 321 \
  --t_model 48 \
  --enc_in 321 \
  --des 'Exp' \
  --itr 1 --batch_size 16  --learning_rate 0.001 >logs/LongForecasting/$model_name'_'electricity_$seq_len'_'192.log  

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/electricity/ \
  --data_path electricity.csv \
  --model_id Electricity_$seq_len'_'336 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6,1] \
  --sconv_kernel [4,8,16,32,3] \
  --period [24,24,24,24,12] \
  --pred_len 336 \
  --d_model 12 \
  --n_model 321 \
  --t_model 48 \
  --enc_in 321 \
  --des 'Exp' \
  --itr 1 --batch_size 16  --learning_rate 0.001  >logs/LongForecasting/$model_name'_'electricity_$seq_len'_'336.log  

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/electricity/ \
  --data_path electricity.csv \
  --model_id Electricity_$seq_len'_'720 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6,1] \
  --sconv_kernel [4,8,16,32,3] \
  --period [24,24,24,24,12] \
  --pred_len 720 \
  --d_model 12 \
  --n_model 321 \
  --t_model 48 \
  --enc_in 321 \
  --des 'Exp' \
  --itr 1 --batch_size 16  --learning_rate 0.001  >logs/LongForecasting/$model_name'_'electricity_$seq_len'_'720.log  

# Exchange_rate   # --conv_kernel [1,3,6,4] \# --period [24,24,24,168] \
seq_len=336
python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/exchange_rate/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_$seq_len'_'96 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,7,1] \
  --sconv_kernel [1,2,4,5] \
  --period [24,30,28,31] \
  --pred_len 96 \
  --d_model 12 \
  --n_model 8 \
  --t_model 48 \
  --enc_in 8 \
  --des 'Exp' \
  --itr 1 --batch_size 8 --learning_rate 0.0005 >logs/LongForecasting/$model_name'_'Exchange_$seq_len'_'96.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/exchange_rate/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_$seq_len'_'192 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,7,1] \
  --sconv_kernel [1,2,4,5] \
  --period [24,30,28,31] \
  --pred_len 192 \
  --d_model 12 \
  --n_model 8 \
  --t_model 48 \
  --enc_in 8 \
  --des 'Exp' \
  --itr 1 --batch_size 8 --learning_rate 0.0005 >logs/LongForecasting/$model_name'_'Exchange_$seq_len'_'192.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/exchange_rate/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_$seq_len'_'336 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,7,1] \
  --sconv_kernel [1,2,4,5] \
  --period [24,30,28,31] \
  --pred_len 336 \
  --d_model 12 \
  --n_model 8 \
  --t_model 48 \
  --enc_in 8 \
  --des 'Exp' \
  --itr 1 --batch_size 32  --learning_rate 0.0005 >logs/LongForecasting/$model_name'_'Exchange_$seq_len'_'336.log 

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/exchange_rate/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_$seq_len'_'720 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,7,1] \
  --sconv_kernel [1,2,4,5] \
  --period [24,30,28,31] \
  --pred_len 720 \
  --d_model 12 \
  --n_model 8 \
  --t_model 48 \
  --enc_in 8 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.0005 >logs/LongForecasting/$model_name'_'Exchange_$seq_len'_'720.log


seq_len=96
# National_illness
python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/illness/ \
  --data_path national_illness.csv \
  --model_id national_illness_$seq_len'_'24 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4] \
  --sconv_kernel [1,2,4] \
  --period [24,56,48] \
  --label_len 18 \
  --pred_len 24 \
  --d_model 12 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.01 >logs/LongForecasting/$model_name'_'ili_$seq_len'_'24.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/illness/ \
  --data_path national_illness.csv \
  --model_id national_illness_$seq_len'_'36 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4] \
   --sconv_kernel [1,2,4] \
  --period [24,56,48] \
  --label_len 18 \
  --pred_len 36 \
  --d_model 12 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.01  >logs/LongForecasting/$model_name'_'ili_$seq_len'_'36.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/illness/ \
  --data_path national_illness.csv \
  --model_id national_illness_$seq_len'_'48 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4] \
   --sconv_kernel [1,2,4] \
  --period [24,56,48] \
  --label_len 18 \
  --pred_len 48 \
  --d_model 12 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.01  >logs/LongForecasting/$model_name'_'ili_$seq_len'_'48.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/illness/ \
  --data_path national_illness.csv \
  --model_id national_illness_$seq_len'_'60 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4] \
   --sconv_kernel [1,2,4] \
  --period [24,56,48] \
  --label_len 18 \
  --pred_len 60 \
  --d_model 12 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.01  >logs/LongForecasting/$model_name'_'ili_$seq_len'_'60.log


seq_len=336
# Etth1
python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTh1.csv \
  --model_id ETTh1_$seq_len'_'96 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTh1 \
  --features M \
  --seq_len $seq_len \
  --pred_len 96 \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005  >logs/LongForecasting/$model_name'_'Etth1_$seq_len'_'96_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTh1.csv \
  --model_id ETTh1_$seq_len'_'192 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTh1 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --pred_len 192 \
  --d_model 96 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Etth1_$seq_len'_'192_s.log
  
  
python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTh1.csv \
  --model_id ETTh1_$seq_len'_'336 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTh1 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --pred_len 336 \
  --d_model 96 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Etth1_$seq_len'_'336_s.log


python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTh1.csv \
  --model_id ETTh1_$seq_len'_'720 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTh1 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --pred_len 720 \
  --d_model 96 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Etth1_$seq_len'_'720_s.log
  
  
# Etth2
python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTh2.csv \
  --model_id ETTh2$seq_len'_'96 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTh2 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --pred_len 96 \
  --d_model 96 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Etth2_$seq_len'_'96_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTh2.csv \
  --model_id ETTh2$seq_len'_'192 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTh2 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --pred_len 192 \
  --d_model 96 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Etth2_$seq_len'_'192_s.log
  
  
python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTh2.csv \
  --model_id ETTh2_$seq_len'_'336 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTh2 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --pred_len 336 \
  --d_model 96 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Etth2_$seq_len'_'336_s.log


python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTh2.csv \
  --model_id ETTh2_$seq_len'_'720 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTh2 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,24,24] \
  --pred_len 720 \
  --d_model 96 \
  --n_model 7 \
  --t_model 96 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Etth2_$seq_len'_'720_s.log
  
  
# Ettm1

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTm1.csv \
  --model_id ETTm1$seq_len'_'96 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTm1 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,96,96] \
  --pred_len 96 \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Ettm1_$seq_len'_'96_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTm1.csv \
  --model_id ETTm1$seq_len'_'192 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTm1 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,96,96] \
  --pred_len 192 \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Ettm1_$seq_len'_'192_s.log
  
  
python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTm1.csv \
  --model_id ETTm1_$seq_len'_'336 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTm1 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,96,96] \
  --pred_len 336 \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Ettm1_$seq_len'_'336_s.log


python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTm1.csv \
  --model_id ETTm1_$seq_len'_'720 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTm1 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,96,96] \
  --pred_len 720 \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Ettm1_$seq_len'_'720_s.log
 
 
 # Ettm2
 
 python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTm2.csv \
  --model_id ETTm2$seq_len'_'96 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTm2 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,96,96] \
  --pred_len 96 \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Ettm2_$seq_len'_'96_s.log

python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTm2.csv \
  --model_id ETTm2$seq_len'_'192 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTm2 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,96,96] \
  --pred_len 192 \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Ettm2_$seq_len'_'192_s.log
  
  
python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTm2.csv \
  --model_id ETTm2_$seq_len'_'336 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTm2 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,96,96] \
  --pred_len 336 \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 32 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Ettm2_$seq_len'_'336_s.log


python -u run_longExp.py \
  --is_training 1 \
  --root_path ./dataset/ETT-small/ \
  --data_path ETTm2.csv \
  --model_id ETTm2_$seq_len'_'720 \
  --model $model_name \
  --train_epochs 10 \
  --patience 3  \
  --data ETTm2 \
  --features M \
  --seq_len $seq_len \
  --conv_kernel [1,3,4,6] \
  --sconv_kernel [1,2,4,5] \
  --period [24,24,96,96] \
  --pred_len 720 \
  --d_model 96 \
  --n_model 7 \
  --t_model 48 \
  --enc_in 7 \
  --dec_in 7  \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 --batch_size 8 --learning_rate 0.005 >logs/LongForecasting/$model_name'_'Ettm2_$seq_len'_'720_s.log
  